from django.utils.html import strip_tags
from django.template.defaultfilters import striptags
from bs4 import BeautifulSoup


class HtmlCleaner:
    """
    Cleaner for HTML text created with multimedia editors, like tinymce, summernote, etc...
    Removes all potential dangerous html code.
    """
    dangerous_tags = [
        'html',
        'head',
        'body',
        'link',
        'script',
        'frameset',
        'frame',
        'iframe',
    ]

    def remove_all_dangerous_tags(self, text: str) -> str:
        soup = BeautifulSoup(text, 'html.parser')
        for tag_name in self.dangerous_tags:
            found_tags = soup(tag_name)
            for tag in found_tags:
                tag.decompose()
        return str(soup)
