from datetime import datetime

from django.db import models

from .queries_cms_legal_docs import QueryCmsLegalDoc


class CmsLegalDocRepository(models.Manager):

    def get_queryset(self) -> models.QuerySet:
        return QueryCmsLegalDoc(self.model)

    def get_last_valid_row_by_code_and_language(self, code: str, language: str) -> [models.Model, None]:
        qs = self.get_queryset().filter(code=code)
        qs = qs.with_date_within_valid_range(date_value=datetime.now())
        qs = qs.with_translated_title_or_default(language=language)
        qs = qs.with_translated_copyright_notice_or_default(language=language)
        qs = qs.with_translated_html_content_or_default(language=language)
        qs = qs.with_translated_html_content_size_or_default(language=language)
        qs = qs.order_by('valid_from')
        return qs.last()
