from django.db import models
from django.utils.translation import gettext_lazy as _


class CmsLegalDocFrench(models.Model):
    """This model stores fields translated to french"""

    class Meta:
        db_table = 'cms_legal_docs_fr'
        verbose_name = _('label_in_french_cms_legal_doc')
        verbose_name_plural = _('label_in_french_cms_legal_docs')

    # fields
    created_at = models.DateField(auto_now_add=True)
    updated_at = models.DateField(auto_now=True)

    parent = models.OneToOneField('CmsLegalDoc', on_delete=models.CASCADE, primary_key=True, related_name='french')
    title = models.CharField(max_length=80, null=False, blank=True, default='')
    copyright_notice = models.CharField(max_length=512, null=False, blank=True, default='')
    html_content = models.TextField(null=False, blank=True, default='')

    parent.verbose_name = _('label_code_cms_legal_doc')
    title.verbose_name = _('label_title_cms_legal_doc')
    copyright_notice.verbose_name = _('label_copyright_notice_cms_legal_doc')
    html_content.verbose_name = _('label_html_content_cms_legal_doc')

    def __str__(self) -> str:
        return str(self.parent.code)

    def save(self, *args, **kwargs) -> None:
        try:
            self.html_content = self.parent.html_cleaner_service.remove_all_dangerous_tags(self.html_content)
        except Exception:
            pass
        super().save(*args, **kwargs)
