from django.db import models
from django.utils.translation import gettext_lazy as _

from services.html_cleaner import HtmlCleaner
from .repositories_cms_legal_docs import CmsLegalDocRepository


class CmsLegalDoc(models.Model):
    """This model stores fields without language translation"""

    class Meta:
        db_table = 'cms_legal_docs'
        verbose_name = _('label_cms_legal_doc')
        verbose_name_plural = _('label_cms_legal_docs')

    # fields
    created_at = models.DateField(auto_now_add=True)
    updated_at = models.DateField(auto_now=True)

    code = models.CharField(max_length=50, null=False, blank=True, default='')
    valid_from = models.DateField(null=True, blank=True)
    valid_until = models.DateField(null=True, blank=True)

    code.verbose_name = _('label_code_cms_legal_doc')
    valid_from.verbose_name = _('label_valid_from_cms_legal_doc')
    valid_until.verbose_name = _('label_valid_until_cms_legal_doc')

    repository = CmsLegalDocRepository()

    def __init__(self, *args, **kwargs) -> None:
        # Do dependencies injection here.
        self.html_cleaner_service: HtmlCleaner = kwargs.pop('html_cleaner_service', HtmlCleaner())
        super().__init__(*args, **kwargs)

    def __str__(self) -> str:
        return str(self.code)
