from reportlab.lib.units import mm
from reportlab.platypus import PageTemplate, Frame

from .invoice_issuer_band import InvoiceIssuerBand
from .timestamp_band import TimestampBand


class InvoicePageTemplate(PageTemplate):
    default_lang = 'en'

    def __init__(self, *args, **kwargs) -> None:
        self.context = kwargs.pop('context', dict())
        self.lang = kwargs.pop('lang', self.default_lang)
        super().__init__(*args, **kwargs)

    def beforeDrawPage(self, canvas, document) -> None:
        canvas.saveState()
        self.frames = [
            Frame(document.leftMargin, document.bottomMargin, document.width, document.height,
                  leftPadding=0,
                  bottomPadding=0,
                  rightPadding=0,
                  topPadding=0,
                  showBoundary=0
                  )
        ]

        # draw timestamp band
        band_max_width = self.pagesize[1] - 0 * mm
        band_max_height = document.leftMargin - 4 * mm
        posx = band_max_height
        posy = 0 * mm
        timestamp_band = TimestampBand(context=self.context, lang=self.lang, max_width=band_max_width,
                                       max_height=band_max_height)
        timestamp_band.drawOn(canvas, posx, posy)

        # draw issuer band
        band_max_width = self.pagesize[1] - 0 * mm
        band_max_height = document.leftMargin - 4 * mm
        posx = self.pagesize[0] - 0 * mm
        posy = 0 * mm
        issuer_band = InvoiceIssuerBand(context=self.context, lang=self.lang, max_width=band_max_width,
                                        max_height=band_max_height)
        issuer_band.drawOn(canvas, posx, posy)

        canvas.restoreState()
