from reportlab.graphics.barcode.qr import QrCode
from reportlab.lib.units import mm


class InvoiceQrCode(QrCode):
    width = 30*mm
    height = 30*mm

    def wrap(self, *args):
        return (self.width, self.height)

    def draw(self):
        self.canv.saveState()
        w = self.width
        h = self.height
        self.canv.setStrokeColorCMYK(0.0, 0.0, 0.0, 0.0)
        self.canv.setFillColorCMYK(0.0, 0.0, 0.0, 0.1)
        self.canv.rect(0, -2 * mm, w, h + 3 * mm, fill=1)
        self.canv.setFillColorCMYK(0.0, 0.0, 0.0, 1.0)
        QrCode.draw(self)
        # restore canvas state
        self.canv.restoreState()
