

class AirplaneButtonTestCase {
    constructor() {
        this.testAction = () => {};
        this.button = new AirplaneButton();

        console.log('Testing method AirplaneButton.setupClickHandler()')
        this.testMethod_setupClickHandler();
    }

    testMethod_setupClickHandler() {
        let is_ok, testFunction;
        /* this assignment should be rejected */
        testFunction = "This is not a function";
        this.button.setupClickHandler(testFunction);
        is_ok = (this.button.onMouseDownHandler != testFunction);
        console.assert(is_ok, "AirplaneButton.setupClickHandler() failed");

        /* this assignment should be accepted */
        testFunction = () => {};
        this.button.setupClickHandler(testFunction);
        is_ok = (this.button.onMouseDownHandler === testFunction);
        console.assert(is_ok, "AirplaneButton.setupClickHandler() failed");
    }
}


class AirplaneKeyboardTestCase {
    constructor() {
        this.testData = {
            inputData: {
                horizontalGridPitch: 25,
                verticalPixels: 180,
                uncleanedSettings: "\n  abc-de-fgh$$$$$$$$$$$$$$$$$  \n  ab-cde-fg  \n  \n   abc-def   ",
                cleanedSettings: "\nABC-DE-FGH\nAB-CDE-FG\n\nABC-DEF",
                rowsData: [
                    "",
                    "ABC-DE-FGH",
                    "AB-CDE-FG",
                    "",
                    "ABC-DEF"
                ]
            },
            expectedAnswer: [
                [
                ],
                [
                    { uid: "1-A", x: 25, y: 0*180/10, width: 25, height: 180/10 },
                    { uid: "1-B", x: 25, y: 1*180/10, width: 25, height: 180/10 },
                    { uid: "1-C", x: 25, y: 2*180/10, width: 25, height: 180/10 },
                    { uid: "1-D", x: 25, y: 4*180/10, width: 25, height: 180/10 },
                    { uid: "1-E", x: 25, y: 5*180/10, width: 25, height: 180/10 },
                    { uid: "1-F", x: 25, y: 7*180/10, width: 25, height: 180/10 },
                    { uid: "1-G", x: 25, y: 8*180/10, width: 25, height: 180/10 },
                    { uid: "1-H", x: 25, y: 9*180/10, width: 25, height: 180/10 }
                ],
                [
                    { uid: "2-A", x: 50, y: 0*180/9, width: 25, height: 180/9 },
                    { uid: "2-B", x: 50, y: 1*180/9, width: 25, height: 180/9 },
                    { uid: "2-C", x: 50, y: 3*180/9, width: 25, height: 180/9 },
                    { uid: "2-D", x: 50, y: 4*180/9, width: 25, height: 180/9 },
                    { uid: "2-E", x: 50, y: 5*180/9, width: 25, height: 180/9 },
                    { uid: "2-F", x: 50, y: 7*180/9, width: 25, height: 180/9 },
                    { uid: "2-G", x: 50, y: 8*180/9, width: 25, height: 180/9 }
                ],
                [
                ],
                [
                    { uid:"3-A", x: 100, y: 0*180/7, width: 25, height: 180/7 },
                    { uid:"3-B", x: 100, y: 1*180/7, width: 25, height: 180/7 },
                    { uid:"3-C", x: 100, y: 2*180/7, width: 25, height: 180/7 },
                    { uid:"3-D", x: 100, y: 4*180/7, width: 25, height: 180/7 },
                    { uid:"3-E", x: 100, y: 5*180/7, width: 25, height: 180/7 },
                    { uid:"3-F", x: 100, y: 6*180/7, width: 25, height: 180/7 }
                ]
            ]
        };

        this.onMouseDownAction = () => {};
        this.keyboard = new AirplaneKeyboard({ onMouseDown: this.onMouseDownAction });

        console.log('Testing method AirplaneKeyboard.setupClickHandler()')
        this.testMethod_setupClickHandler();

        console.log('Testing method AirplaneKeyboard.makeButtonUID()')
        this.testMethod_makeButtonUID();

        console.log('Testing method AirplaneKeyboard.parseSingleButtonSettings()')
        this.testMethod_parseSingleButtonSettings();

        console.log('Testing method AirplaneKeyboard.parseKeyboardRowSettings()')
        this.testMethod_parseKeyboardRowSettings();

        console.log('Testing method AirplaneKeyboard.parseKeyboardGridSettings()')
        this.testMethod_parseKeyboardGridSettings();

        console.log('Testing method AirplaneKeyboard.cleanSettings()')
        this.testMethod_cleanSettings();
    }

    testMethod_setupClickHandler() {
        let is_ok, testFunction;
        /* this assignment should be rejected */
        testFunction = "This is not a function";
        this.keyboard.setupClickHandler(testFunction);
        is_ok = (this.keyboard.onMouseDownHandler != testFunction);
        console.assert(is_ok, "AirplaneButton.setupClickHandler() failed");

        /* this assignment should be accepted */
        testFunction = () => {};
        this.keyboard.setupClickHandler(testFunction);
        is_ok = (this.keyboard.onMouseDownHandler === testFunction);
        console.assert(is_ok, "AirplaneButton.setupClickHandler() failed");
    }

    testMethod_cleanSettings() {
        let inputData = this.testData.inputData.uncleanedSettings;
        let expectedAnswer = this.testData.inputData.cleanedSettings;

        let answer = this.keyboard.cleanSettings(inputData);
        let is_ok = (answer == expectedAnswer);
        console.assert(is_ok, "AirplaneKeyboard.cleanSettings() failed");
    }

    testMethod_parseKeyboardGridSettings() {
        let cleanedSettings = this.testData.inputData.cleanedSettings;
        let horizontalGridPitch = this.testData.inputData.horizontalGridPitch;
        let verticalPixels = this.testData.inputData.verticalPixels;
        let expectedAnswer = this.testData.expectedAnswer;

        let answer = this.keyboard.parseKeyboardGridSettings(
            cleanedSettings,
            horizontalGridPitch,
            verticalPixels
        );
        let is_ok = (JSON.stringify(answer) === JSON.stringify(expectedAnswer));
        console.assert(is_ok, "AirplaneKeyboard.parseKeyboardGridSettings() failed");
    }

    testMethod_parseKeyboardRowSettings() {
        let rowsData = this.testData.inputData.rowsData;
        let rowsCount = rowsData.length;
        let horizontalGridPitch = this.testData.inputData.horizontalGridPitch;
        let verticalPixels = this.testData.inputData.verticalPixels;
        let expectedAnswer = this.testData.expectedAnswer;

        let nonEmptyRowsIndex = 1;
        for (let rowIndex=0; rowIndex < rowsCount; rowIndex++) {
            let rowName = nonEmptyRowsIndex.toString();
            let rowData = rowsData[rowIndex]
            let answer = this.keyboard.parseKeyboardRowSettings(
                rowIndex,
                rowName,
                rowData,
                horizontalGridPitch,
                verticalPixels
            );
            let is_ok = (JSON.stringify(answer) === JSON.stringify(expectedAnswer[rowIndex]));
            console.assert(is_ok, `AirplaneKeyboard.parseKeyboardRowSettings() failed on input: ${rowsData[rowIndex]}`);
            if (rowData.length > 0) {
                nonEmptyRowsIndex++;
            }
        }
    }

    testMethod_parseSingleButtonSettings() {
        let inputData = {
            rowIndex: 3,
            rowName: "4",
            seatIndex: 4,
            seatName: "D",
            horizontalGridPitch: 25,
            verticalGridPitch: 20
        };
        let expectedAnswer = { uid: "4-D", x: 75, y: 80, width: 25, height: 20, onMouseDown: this.onMouseDownAction };

        let answer = this.keyboard.parseSingleButtonSettings(
            inputData.rowIndex,
            inputData.rowName,
            inputData.seatIndex,
            inputData.seatName,
            inputData.horizontalGridPitch,
            inputData.verticalGridPitch
        );
        let is_ok = (JSON.stringify(answer) === JSON.stringify(expectedAnswer));
        console.assert(is_ok, "AirplaneKeyboard.parseSingleButtonSettings() failed");
    }

    testMethod_makeButtonUID() {
        let name;
        name = this.keyboard.makeButtonUID(1, "A");
        console.assert((name === "1-A"), "AirplaneKeyboard.makeButtonUID() failed");
        name = this.keyboard.makeButtonUID("1", "A");
        console.assert((name === "1-A"), "AirplaneKeyboard.makeButtonUID() failed");
    }
}
