
class AirplaneButton {
    domNamespace = "http://www.w3.org/2000/svg";

    defaultUID = "0-A";
    defaultIsAvailable = true;

    defaultPositionX = 0;
    defaultPositionY = 0;
    defaultWidth = 25;
    defaultHeight = 20;
    defaultRadiusX = 1;
    defaultRadiusY = 1;
    defaultStrokeWidth = 1;
    defaultStrokeColor = "gray";
    defaultAvailableFillColor = "rgb(220, 255, 220)";
    defaultNotAvailableFillColor = "rgb(250, 200, 200)";
    defaultHighlightedFillColor = "rgb(0, 220, 0)";

    defaultOnMouseDownHandler = (button) => { alert(`AirplaneButtonClass: clicked on  ${button.uid}`); };

    constructor(settings={}) {
        this.uid = (typeof(settings.uid)=='string') ? settings.uid : this.defaultUID;
        this.x = (typeof(settings.x)=='number') ? settings.x : this.defaultPositionX;
        this.y = (typeof(settings.y)=='number') ? settings.y : this.defaultPositionY;
        this.width = (typeof(settings.width)=='number') ? settings.width : this.defaultWidth;
        this.height = (typeof(settings.height)=='number') ? settings.height : this.defaultHeight;
        this.rx = (typeof(settings.rx)=='number') ? settings.rx : this.defaultRadiusX;
        this.ry = (typeof(settings.ry)=='number') ? settings.ry : this.defaultRadiusY;
        this.stroke = (typeof(settings.stroke)=='string') ? settings.stroke : this.defaultStrokeColor;
        this.strokeWidth = (typeof(settings.strokeWidth)=='number') ? settings.strokeWidth : this.defaultStrokeWidth;

        this.onMouseDownHandler = this.defaultOnMouseDownHandler;

        this.domNode = this.domSetup();

        this.isAvailable = (settings.isAvailable) ? settings.isAvailable : this.defaultIsAvailable;
        (this.isAvailable) ? this.renderAvailable() : this.renderNotAvailable();
    }

    domSetup() {
        let node = document.createElementNS(this.domNamespace, "rect");
        node.setAttribute('x', `${this.x + 1}`);
        node.setAttribute('y', `${this.y + 1}`);
        node.setAttribute('width', `${this.width - 2 }`);
        node.setAttribute('height', `${this.height - 2}`);
        node.setAttribute('rx', `${this.rx}`);
        node.setAttribute('ry', `${this.ry}`);
        node.setAttribute('stroke', `${this.stroke}`);
        node.setAttribute('strokeWidth', `${this.strokeWidth}`);

        let titleNode = document.createElementNS(this.domNamespace, "title");
        titleNode.appendChild(document.createTextNode(this.uid));
        node.appendChild(titleNode);

        node.onmouseover = (event) => { this.onMouseOverAction(event); };
        node.onmouseleave = (event) => { this.onMouseLeaveAction(event); };
        node.onmousedown = (event) => { this.onMouseDownAction(event); };

        return node;
    }

    setupClickHandler(hookFunction) {
        if (typeof(hookFunction) == 'function') {
            this.onMouseDownHandler = hookFunction;
        }
    }

    onMouseOverAction(event) {
        (this.isAvailable) ? this.renderHighlighted() : this.renderNotAvailable();
    }

    onMouseLeaveAction(event) {
        (this.isAvailable) ? this.renderAvailable() : this.renderNotAvailable();
    }

    onMouseDownAction(event) {
        if (this.isAvailable) {
            this.isAvailable = false;
            if (typeof(this.onMouseDownAction) == 'function') {
                this.onMouseDownHandler(this);
            }
        }
    }

    renderAvailable() {
        this.domNode.setAttribute('fill', this.defaultAvailableFillColor);
        this.domNode.setAttribute('cursor', "default");
    }

    renderNotAvailable() {
        this.domNode.setAttribute('fill', this.defaultNotAvailableFillColor);
        this.domNode.setAttribute('cursor', "not-allowed");
    }

    renderHighlighted() {
        this.domNode.setAttribute('fill', this.defaultHighlightedFillColor);
        this.domNode.setAttribute('cursor', "pointer");
    }
}
