from django import forms
from django_summernote.widgets import SummernoteWidget

from ..models import CmsLegalDoc


class CmsLegalDocForm(forms.ModelForm):
    class Meta:
        model = CmsLegalDoc
        fields = ['code', 'valid_from', 'valid_until']

        widgets = {
            'html_content': SummernoteWidget(attrs={
                'summernote': {
                    'lang': None,
                    'disable_attachment': True,
                    'toolbar': [
                        ['style', ['style']],
                        ['font', ['bold', 'underline', 'clear']],
                        ['fontname', ['fontname']],
                        ['color', ['color']],
                        ['para', ['ul', 'ol', 'paragraph']],
                        ['insert', ['link']],
                        ['view', ['fullscreen', 'codeview', 'help']],
                    ],
                },
            }),
        }
