from django.contrib import admin
from django.db import models
from django.utils.translation import gettext_lazy as _

from .cms_legal_docs_forms import *
from ..models import CmsLegalDocSpanish


class CmsLegalDocSpanishInline(admin.StackedInline):
    form = CmsLegalDocForm
    model = CmsLegalDocSpanish
    show_change_link = False
    can_delete = False
    verbose_name = _('label_spanish_version_cms_legal_doc')
    verbose_name_plural = _('label_spanish_version_cms_legal_doc')
    fieldsets = [
        (' ', {'fields': ['title', 'copyright_notice', 'html_content'], 'classes': ['collapse']}),
    ]


@admin.register(CmsLegalDocSpanish)
class CmsLegalDocSpanishAdmin(admin.ModelAdmin):
    form = CmsLegalDocForm

    save_on_top = True

    list_display = [
        'parent',
        'title',
    ]
    list_display_links = [
        'parent',
        'title',
    ]
    fields = [
        'parent',
        'title',
        'copyright_notice',
        'html_content',
    ]
    ordering = ['parent__code']
    formfield_overrides = {
        models.TextField: {"widget": SummernoteWidget()},
    }
