from django.contrib import admin
from .admin_cms_legal_docs_ca import CmsLegalDocCatalanInline
from .admin_cms_legal_docs_en import CmsLegalDocEnglishInline
from .admin_cms_legal_docs_es import CmsLegalDocSpanishInline
from .admin_cms_legal_docs_fr import CmsLegalDocFrenchInline
from .admin_cms_legal_docs_it import CmsLegalDocItalianInline
from .admin_cms_legal_docs_pt import CmsLegalDocPortugueseInline
from .cms_legal_docs_forms import CmsLegalDocForm
from ..models import CmsLegalDoc


@admin.register(CmsLegalDoc)
class CmsLegalDocAdmin(admin.ModelAdmin):
    form = CmsLegalDocForm

    save_on_top = True

    list_display = [
        'code',
        'valid_from',
        'valid_until',
    ]
    list_display_links = [
        'code',
        'valid_from',
        'valid_until',
    ]
    fields = [
        'code',
        ('valid_from', 'valid_until'),
    ]
    ordering = ['code']

    inlines = [
        CmsLegalDocEnglishInline,
        CmsLegalDocSpanishInline,
        CmsLegalDocFrenchInline,
        CmsLegalDocItalianInline,
        CmsLegalDocPortugueseInline,
        CmsLegalDocCatalanInline,
    ]
