
class AirplaneOutline {
    domNamespace = "http://www.w3.org/2000/svg";
    drawingPaths = [
        /* top wing */
        { "element": "path", "d": "M 450 60 L 495 0", "stroke": "lightgray", "strokeWidth": "3", "fill": "transparent" },
        { "element": "path", "d": "M 810 60 L 827 0", "stroke": "lightgray", "strokeWidth": "1", "fill": "transparent" },
        { "element": "path", "d": "M 850 60 L 867 0", "stroke": "lightgray", "strokeWidth": "3", "fill": "transparent" },
        /* bottom wing */
        { "element": "path", "d": "M 450 240 L 495 300", "stroke": "lightgray", "strokeWidth": "3", "fill": "transparent" },
        { "element": "path", "d": "M 810 240 L 827 300", "stroke": "lightgray", "strokeWidth": "1", "fill": "transparent" },
        { "element": "path", "d": "M 850 240 L 867 300", "stroke": "lightgray", "strokeWidth": "3", "fill": "transparent" },
        /* top left toilet */
        { "element": "rect", "x": "190", "y": "61", "width": "60", "height": "45", "rx": "3", "ry": "3", "fill": "lightgray" },
        { "element": "text", "x": "220", "y": "85", "textAnchor": "middle", "dominantBaseLine": "central", "fill": "gray", "fontFamily": "Arial, Helvetica", "fontWeight": "bold", "fontSize": "12", "text": "WC" },
        /* bottom left toilet */
        { "element": "rect", "x": "190", "y": "194", "width": "60", "height": "45", "rx": "3", "ry": "3", "fill": "lightgray" },
        { "element": "text", "x": "220", "y": "218", "textAnchor": "middle", "dominantBaseLine": "central", "fill": "gray", "fontFamily": "Arial, Helvetica", "fontWeight": "bold", "fontSize": "12", "text": "WC" },
        /* top right toilet */
        { "element": "rect", "x": "1050", "y": "61", "width": "60", "height": "45", "rx": "3", "ry": "3", "fill": "lightgray" },
        { "element": "text", "x": "1080", "y": "85", "textAnchor": "middle", "dominantBaseLine": "central", "fill": "gray", "fontFamily": "Arial, Helvetica", "fontWeight": "bold", "fontSize": "12", "text": "WC" },
        /* bottom right toilet */
        { "element": "rect", "x": "1050", "y": "194", "width": "60", "height": "45", "rx": "3", "ry": "3", "fill": "lightgray" },
        { "element": "text", "x": "1080", "y": "218", "textAnchor": "middle", "dominantBaseLine": "central", "fill": "gray", "fontFamily": "Arial, Helvetica", "fontWeight": "bold", "fontSize": "12", "text": "WC" },
        /* passengers room separation */
        { "element": "path", "d": "M 250 240 L 250 60", "stroke": "lightgray", "strokeWidth": "1", "fill": "transparent" },
        { "element": "path", "d": "M 1050 240 L 1050 60", "stroke": "lightgray", "strokeWidth": "1", "fill": "transparent" },
        /* airplane frame */
        { "element": "path", "d": "M 250 60 L 1050 60", "stroke": "gray", "strokeWidth": "3", "fill": "transparent" },
        { "element": "path", "d": "M 250 240 L 1050 240", "stroke": "gray", "strokeWidth": "3", "fill": "transparent" },
        { "element": "path", "d": "M 250 60 C -70 60 -70 240 250 240", "stroke": "gray", "strokeWidth": "3", "fill": "transparent" },
        { "element": "path", "d": "M 1050 60 C 1500 60 1500 240 1050 240", "stroke": "gray", "strokeWidth": "3", "fill": "transparent" },
        /* top center exit */
        { "element": "rect", "x": "620", "y": "32", "width":"60", "height": "22", "rx": "3", "ry": "3", "fill": "red" },
        { "element": "text", "x": "650", "y": "42", "textAnchor": "middle", "dominantBaseLine": "central", "fill": "white", "fontFamily": "Arial, Helvetica", "fontWeight": "bold", "fontSize": "12", "text": "EXIT" },
        /* bottom left exit */
        { "element": "rect", "x": "120", "y": "245", "width":"60", "height": "22", "rx": "3", "ry": "3", "fill": "red" },
        { "element": "text", "x": "150", "y": "255", "textAnchor": "middle", "dominantBaseLine": "central", "fill": "white", "fontFamily": "Arial, Helvetica", "fontWeight": "bold", "fontSize": "12", "text": "EXIT" },
        /* bottom center exit */
        { "element": "rect", "x": "620", "y": "245", "width":"60", "height": "22", "rx": "3", "ry": "3", "fill": "red" },
        { "element": "text", "x": "650", "y": "255", "textAnchor": "middle", "dominantBaseLine": "central", "fill": "white", "fontFamily": "Arial, Helvetica", "fontWeight": "bold", "fontSize": "12", "text": "EXIT" },
        /* bottom right exit */
        { "element": "rect", "x": "1120", "y": "245", "width":"60", "height": "22", "rx": "3", "ry": "3", "fill": "red" },
        { "element": "text", "x": "1150", "y": "255", "textAnchor": "middle", "dominantBaseLine": "central", "fill": "white", "fontFamily": "Arial, Helvetica", "fontWeight": "bold", "fontSize": "12", "text": "EXIT" },
    ];

    constructor() {
        this.domNode = this.domSetup();
    }

    domSetup() {
        let parentNode = document.createElementNS(this.domNamespace, "svg");
        for (let item of this.drawingPaths) {
            switch(item.element) {
                case "path": parentNode.appendChild(this.createPathNode(item));
                             break;
                case "rect": parentNode.appendChild(this.createRectNode(item));
                             break;
                case "text": parentNode.appendChild(this.createTextNode(item));
                             break;
            }
        }
        return parentNode;
    }

    createPathNode(item) {
        let node = document.createElementNS(this.domNamespace, 'path');
        node.setAttribute('d', item.d);
        node.setAttribute('stroke', item.stroke);
        node.setAttribute('stroke-width', item.strokeWidth);
        node.setAttribute('fill', item.fill);
        return node
    }

    createRectNode(item) {
        let node = document.createElementNS(this.domNamespace, 'rect');
        node.setAttribute('x', item.x);
        node.setAttribute('y', item.y);
        node.setAttribute('width', item.width);
        node.setAttribute('height', item.height);
        node.setAttribute('rx', item.rx);
        node.setAttribute('ry', item.ry);
        node.setAttribute('fill', item.fill);
        return node
    }

    createTextNode(item) {
        let node = document.createElementNS(this.domNamespace, "text");
        node.setAttribute("x", item.x);
        node.setAttribute("y", item.y);
        node.setAttribute("fill", item.fill);
        node.setAttribute("text-anchor", item.textAnchor);
        node.setAttribute("dominant-baseline", item.dominantBaseLine);
        node.setAttribute("font-family", item.fontFamily);
        node.setAttribute("font-size", item.fontSize);
        node.setAttribute("font-weight", item.fontWeight);
        node.appendChild(document.createTextNode(item.text));
        return node
    }
}

