
class AirplaneSVG {
    domNamespace = "http://www.w3.org/2000/svg";

    defaultSvgX = 0;
    defaultSvgY = 0;
    defaultSvgWidth = 1250;
    defaultSvgHeight = 300;
    defaultSvgBackgroundColor = "white";

    defaultOutlineClass = AirplaneOutline;
    defaultKeyboardClass = AirplaneKeyboard;

    constructor(settings={}) {
        /* dependencies injection */
        this.outlineClass = (typeof(settings.outlineClass)=='function')
            ? settings.outlineClass
            : this.defaultOutlineClass;
        this.outline = new this.outlineClass();

        this.keyboardClass = (typeof(settings.keyboardClass)=='function')
            ? settings.keyboardClass
            : this.defaultKeyboardClass;
        this.keyboard = new this.keyboardClass();

        /* other settings */
        this.svgX = (typeof(settings.svgX)=='number') ? settings.svgX : this.defaultSvgX;
        this.svgY = (typeof(settings.svgY)=='number') ? settings.svgY : this.defaultSvgY;
        this.svgWidth = (typeof(settings.svgWidth)=='number') ? settings.svgWidth : this.defaultSvgWidth;
        this.svgHeight = (typeof(settings.svgHeight)=='number') ? settings.svgHeight : this.defaultSvgHeight;

        this.svgBackgroundColor = (typeof(settings.svgBackgroundColor)=='string')
            ? settings.svgBackgroundColor
            : this.defaultSvgBackgroundColor;

        this.viewBox = `${0} ${0} ${this.svgWidth} ${this.svgHeight}`;

        this.domNode = this.domParentNodeSetup();
        this.domNode.appendChild(this.outline.domNode);
        this.domNode.appendChild(this.keyboard.domNode);
    }

    domParentNodeSetup() {
        let node = document.createElementNS(this.domNamespace, "svg");
        node.setAttribute('viewBox', this.viewBox);
        node.setAttribute('width', "100%");
        node.setAttribute('height', "100%");
        node.style.backgroundColor = this.svgBackgroundColor;
        return node;
    }
}

